-- Memory card helpers
function IsMemcardEnabled()
	return PREFSMAN:GetPreference("MemoryCards") and PREFSMAN:GetPreference("MemoryCardProfiles")
end;


function GetMemcardPath(player)
	if player == PLAYER_1 then
		return "/@mc1/"
	else
		return "/@mc2/"
	end;
end;

function GetMemcardProfileDir(player)
	return GetMemcardPath(player)..PREFSMAN:GetPreference("MemoryCardProfileSubdir").."/"
end;

function DoesMemcardProfileExist(player)
	return FILEMAN:DoesFileExist(GetMemcardProfileDir(player).."Stats.xml");
end;

--This is never even used and should be removed because it doesn't work
function LoadMemcardProfileData(player)
	local filePath = GetMemcardProfileDir(player).."rioStats.ini"
	if FILEMAN:DoesFileExist(filePath) then
		local file = RageFileUtil.CreateRageFile();
		file:Open(filePath,1) --Access type: Read
		local s = file:Read();
		s = split("\n",s)
		profileCache = {};
		for line in ivalues(s) do
			--Warn(trimStr(s[k]));
			values = split("=",trimStr(line))
			--assert(values[2],"val for key "..values[1].." was nil");
			--Warn(values[1].."="..values[2])
			
			if values[1] == "Name" then
				profileCache["DisplayName"]=values[2];
			elseif values[1] == "PlayCount" then
				profileCache["NumTotalSongsPlayed"]=tonumber(values[2]);
			elseif values[1] == "DP" then
				profileCache["DancePoints"]=values[2];
			elseif values[1] == "Calories" then
				profileCache["TotalCaloriesBurned"]=values[2];
			elseif values[1] == "Steps" then
				profileCache["TotalTapsAndHolds"]=values[2];
			end;
		end;
		file:Close()
		file:destroy();
		return profileCache;
	else
		SCREENMAN:SystemMessage(player.." profile does not exist... "..filePath)
	end;
	return nil;
end;

--Only call this on logout!!!
function SaveMemcardProfileData(player)
	local profile = PROFILEMAN:GetProfile(player)
	local dir;
	if player == PLAYER_1 then
		dir = PROFILEMAN:GetProfileDir('ProfileSlot_Player1')
	else
		dir = PROFILEMAN:GetProfileDir('ProfileSlot_Player2')
	end;
	local file = RageFileUtil.CreateRageFile();
	file:Open(dir.."rioStats.ini", 2) --access type: 2(write)
	--file:PutLine("Autogenerated by RIO, do not edit.");
	file:PutLine("Name="..profile:GetDisplayName());
	file:PutLine("DP="..tostring(profile:GetTotalDancePoints()));
	file:PutLine("PlayCount="..tostring(profile:GetNumTotalSongsPlayed()));
	file:PutLine("Calories="..math.floor(profile:GetTotalCaloriesBurned()));
	file:PutLine("Steps="..profile:GetTotalTapsAndHolds());
	file:Close();
	file:destroy();
end;